/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.university;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TryResearchMessage
extends AbstractBuildingServerMessage<BuildingUniversity> {
    private ResourceLocation researchId;
    private ResourceLocation branch;
    private boolean reset;

    public TryResearchMessage() {
    }

    public TryResearchMessage(IBuildingView building, @NotNull ResourceLocation researchId, ResourceLocation branch, boolean reset) {
        super(building);
        this.researchId = researchId;
        this.branch = branch;
        this.reset = reset;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.researchId = buf.func_192575_l();
        this.branch = buf.func_192575_l();
        this.reset = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_192572_a(this.researchId);
        buf.func_192572_a(this.branch);
        buf.writeBoolean(this.reset);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingUniversity building) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, this.researchId);
        if (this.reset) {
            if (colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId) != null) {
                colony.getResearchManager().getResearchTree().attemptResetResearch((PlayerEntity)player, colony, colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId));
            }
        } else if (research.canResearch(building.getBuildingLevel() == building.getMaxBuildingLevel() ? Integer.MAX_VALUE : building.getBuildingLevel(), colony.getResearchManager().getResearchTree()) || player.func_184812_l_()) {
            colony.getResearchManager().getResearchTree().attemptBeginResearch((PlayerEntity)player, colony, research);
        }
    }
}

